#include <windows>
#pragma option push -a1
   #include <setupapi>
#pragma option pop
#include <iostream>
#include "D:\\WINDDK\\7600.16385.1\\inc\\api\\usbioctl.h"

using namespace std;

//---------------------------------------------------------
void getRootHubName(HANDLE devHandle) 
{
  USB_ROOT_HUB_NAME rootHubName;
  PUSB_ROOT_HUB_NAME pRootHubName;
  DWORD outBufferSize, bytesReturned;
  if (DeviceIoControl(devHandle, IOCTL_USB_GET_ROOT_HUB_NAME,
      &rootHubName, sizeof(rootHubName), &rootHubName,
      sizeof(rootHubName), &outBufferSize, NULL)) {
      outBufferSize = rootHubName.ActualLength;
      pRootHubName = new USB_ROOT_HUB_NAME[outBufferSize];
      if (DeviceIoControl(devHandle, IOCTL_USB_GET_ROOT_HUB_NAME,
          &rootHubName, sizeof(rootHubName), pRootHubName,
          outBufferSize, &bytesReturned, NULL)) {
          printf("\nRoot Hub USB:\n%ls\n",&pRootHubName->RootHubName[0]);
      };
      delete [] pRootHubName;
  };
  return;
};
//-----------------------------------------------------
void getHCDDriverKeyName(HANDLE devHandle) 
{
  USB_HCD_DRIVERKEY_NAME driverKeyName;
  PUSB_HCD_DRIVERKEY_NAME pDriverKeyName;
  DWORD outBufferSize, bytesReturned;
  if (DeviceIoControl(devHandle, IOCTL_GET_HCD_DRIVERKEY_NAME,
      &driverKeyName, sizeof(driverKeyName), &driverKeyName,
      sizeof(driverKeyName), &outBufferSize, NULL)) {
      outBufferSize = driverKeyName.ActualLength;
      pDriverKeyName = new USB_HCD_DRIVERKEY_NAME[outBufferSize];
      if (DeviceIoControl(devHandle, IOCTL_GET_HCD_DRIVERKEY_NAME,
          &driverKeyName, sizeof(driverKeyName), pDriverKeyName,
          outBufferSize, &bytesReturned, NULL)) {
          printf("\nIdentyfikacja standardowego rozszerzonego kontrolera PCI do USB: \n%ls\n",&pDriverKeyName->DriverKeyName[0]);
      }
    delete [] pDriverKeyName;
  };
};
//---------------------------------------------------------
int main()
{
   HANDLE HCDHandle; //HCD - Host Controller Driver
   char HCDName[] = "\\\\.\\HCD0";
   UINT i = 0;
   do {
       HCDName[7] = i + '0';
       HCDHandle = CreateFile(HCDName, GENERIC_WRITE, FILE_SHARE_WRITE,
                              NULL, OPEN_EXISTING, 0 , NULL);

       if (HCDHandle != INVALID_HANDLE_VALUE) {
          getRootHubName(HCDHandle);
          getHCDDriverKeyName(HCDHandle);
          CloseHandle(HCDHandle);
       }
       i++;
   } while(HCDHandle != INVALID_HANDLE_VALUE);
   system("PAUSE");
   return 0;
}
//---------------------------------------------------------

